// ============================================================
//  SaverModule.cpp	1996 Hiroshi Lockheimer
// ============================================================

#include "SaverModule.h"
#include "TDotsWindow.h"
#include "TControlSlide.h"
#include "TTabView.h"
#include "dots.h"


// Uncomment the following line to prevent 'Random' from calling
// your module

//char inhibit_random = 1;

dots_param*	gTheSettings;
static gConfiguring = 0;
static TDotsWindow*	gWindow;

int main (int argc, char** argv)
{
	printf ("This is ElectronStorm\n");
}

// ------------------------------------------------------------
// 		 module_initialize  [optional]
// ------------------------------------------------------------
// This function gets called once, immediately after saver has
// loaded your module
//
// It is not known at this point whether you are being loaded
// to save the screen or to configure yourself (or both)
//
// inSettings is a pointer to data inSettingsSize long that saver 
// has stored for you, it is your responsibility to free it before 
// your module is unloaded
//
// saver may pass you NULL and 0 if it cannot find any data that
// belongs to you

void
module_initialize(
	void	*inSettings,
	long	inSettingsSize)
{
	gDefSettings = (dots_param*)malloc (sizeof(dots_param));
	CopySettingsOut(gDefSettings);
	gDefSettings->CloverRotation = 300;

	if ( inSettings == NULL  || inSettingsSize != sizeof(dots_param) )
	{
		gTheSettings = (dots_param*)malloc (sizeof(dots_param));
		CopySettingsOut(gTheSettings);
		gTheSettings->CloverRotation = 300;
	}
	else
	{	
		gTheSettings = (dots_param*)inSettings;
		CopySettingsIn(gTheSettings);
	}	

} 


// ------------------------------------------------------------
// 		 module_cleanup  [optional]
// ------------------------------------------------------------
// This function gets called once, immediately before saver will
// unload your module
//
// This is the last chance to clean up after yourself
//
// Set outSettings to a pointer that is outSettingsSize long, 
// and saver will store it for you until the next time your module 
// is loaded
//
// Pass back NULL and 0 if you do not need to store anything
//
// Do not attempt to free what you pass back to saver

void
module_cleanup(
	void	**outSettings,
	long	*outSettingsSize)
{
	*outSettings = gTheSettings;
	*outSettingsSize = sizeof(dots_param);
	
//	free (gDefSettings);
}


// ------------------------------------------------------------
// 		 module_start_saving  [required]
// ------------------------------------------------------------
// This function gets called when it is time to "save" the screen
// Spawn your thread(s) here and return from this function ASAP
//
// You are given a BView in which you are to do your work
// Do all your drawing in inView, or in its children (if you 
// decide to add any)
//
// The window in which the BView resides is not shown at this time,
// it is your responsibility to inView->Window()->Show() it
//
// inView's View and Low color are set to black, High color is white
//
// saver never locks inView's window for you, so be sure to
// inView->Window()->Lock() before you try to do anything with
// inView, otherwise you win a free trip to the debugger

void
module_start_saving(
	BView	*inView)
{
	if ( gConfiguring == 1)
		GetSettings();
	
	status_t error;
	gWindow = new TDotsWindow(gTheSettings->screen,"Dots Screen", &error);
	
//	gWindow->Lock();
//	gWindow->AddChild(inView);
//	gWindow->Unlock();
	gWindow->Show();
}


// ------------------------------------------------------------
// 		 module_stop_saving  [required]
// ------------------------------------------------------------
// This function gets called right before the BWindow that
// you have been drawing into gets closed
//
// Exit from all your thread(s), free any memory that you no 
// longer need, unlock anything that you locked, be good and 
// clean up after yourself

void
module_stop_saving()
{
	gWindow->Quit();
}


// ------------------------------------------------------------
// 		 module_start_config  [required]
// ------------------------------------------------------------
// This function gets called when the user has selected your 
// module in the settings panel
//
// You are free to add any children to inView or modify it
// in any way (but don't even think about deleting it)
//
// inView is 241.0 units wide and 244.0 units high

void
module_start_config(
	BView *inView)
{
	if (!inView->Window()->Lock())
		return;
		
	BRect frame;
	BStringView	*view;
	
	long	theControlTop = inView->Bounds().top + 40;
	
	frame = inView->Bounds();
	frame.InsetBy(5,5);
	
	TTabView *theTabView = new TTabView(frame, "TabView", B_FOLLOW_ALL,B_WILL_DRAW);
	theTabView->SetViewColor(inView->ViewColor());
	inView->AddChild(theTabView);
	
	frame = theTabView->Bounds();
	BView	*theCredits = new BView(frame, B_EMPTY_STRING, 0,B_WILL_DRAW);
	theCredits->SetViewColor(inView->ViewColor());
	theTabView->AddChild(theCredits,"Credits");
	
	frame = theTabView->Bounds();
	BView	*theScreen = new BView(frame, B_EMPTY_STRING, B_FOLLOW_ALL,B_WILL_DRAW);
	theScreen->SetViewColor(inView->ViewColor());
	theTabView->AddChild(theScreen,"General");	

	frame = theTabView->Bounds();
	BView	*theSettings = new BView(frame, B_EMPTY_STRING, 0,B_WILL_DRAW);
	theSettings->SetViewColor(inView->ViewColor());
	theTabView->AddChild(theSettings,"Dots");	
	
	frame = theTabView->Bounds();
	BView	*theShells = new BView(frame, B_EMPTY_STRING, B_FOLLOW_ALL,B_WILL_DRAW);
	theShells->SetViewColor(inView->ViewColor());
	theTabView->AddChild(theShells,"Shells");	

// Setup Credit Text
	frame = theCredits->Bounds();
	frame.InsetBy(5,5);

	theControlTop=10;
	frame.top += theControlTop;
	frame.left += 10;
	frame.bottom = frame.top + 15.0;

	view = new BStringView(frame, B_EMPTY_STRING, "Electron Storm 1.1");

	theCredits->AddChild(view);
	view->SetViewColor(theCredits->ViewColor());
	view->SetFont(be_bold_font);

	theControlTop=10;
	frame = theCredits->Bounds();
	frame.InsetBy (5,5);
	frame.top += theControlTop;

	BTextView *theText = new BTextView(frame, "", frame,B_FOLLOW_ALL,B_WILL_DRAW);
	
	char *theRealText = "  by Dirk Steins (dsteins@ibm.net)\n\n"
						"Original version by Trevor Walker (twalker@carroll1.cc.edu),\n\n"
						"This module is freeware, but"  
						"if you like it drop me or Trevor a mail.";
	theCredits->AddChild(theText);
	theText->SetViewColor(theCredits->ViewColor());
	theText->SetLowColor(theCredits->ViewColor());
	theText->SetText(theRealText);
	theText->SetWordWrap(TRUE);
	theText->SetAutoindent(FALSE);
	theText->MakeSelectable(FALSE);


	frame = theShells->Bounds();
	frame.InsetBy(5,5);
	TTabView *theShellTab = new TTabView(frame, "ShellTab", B_FOLLOW_ALL,B_WILL_DRAW);
	theShellTab->SetViewColor(inView->ViewColor());
	theShells->AddChild(theShellTab);

	frame = theShellTab->Bounds();
	BView	*theClover = new BView(frame, B_EMPTY_STRING, B_FOLLOW_ALL,B_WILL_DRAW);
	theClover->SetViewColor(inView->ViewColor());
	theShellTab->AddChild(theClover,"Clover");
	
	frame = theShellTab->Bounds();
	BView	*theRing = new BView(frame, B_EMPTY_STRING, B_FOLLOW_ALL,B_WILL_DRAW);
	theRing->SetViewColor(inView->ViewColor());
	theShellTab->AddChild(theRing,"Ring");
	
	frame = theShellTab->Bounds();
	BView	*theCircle = new BView(frame, B_EMPTY_STRING, B_FOLLOW_ALL,B_WILL_DRAW);
	theCircle->SetViewColor(inView->ViewColor());
	theShellTab->AddChild(theCircle,"Circle");
	
	frame = theShellTab->Bounds();
	BView	*theSphere = new BView(frame, B_EMPTY_STRING, B_FOLLOW_ALL,B_WILL_DRAW);
	theSphere->SetViewColor(inView->ViewColor());
	theShellTab->AddChild(theSphere,"Sphere");
	
	
	
// Create Screen view
	theControlTop = 5;
	frame = theScreen->Bounds();
	frame.top += theControlTop;
	frame.left += 10.0;
	frame.bottom = frame.top + 12.0;
	view = new BStringView(frame, B_EMPTY_STRING, "Screen Resolution");
	theScreen->AddChild(view);
	view->SetViewColor(theScreen->ViewColor());

// Add Radio Buttons	RadioButton.h
	theControlTop +=20;
	frame = theScreen->Bounds();
	frame.top += theControlTop;
	frame.bottom = frame.top + B_H_SCROLL_BAR_HEIGHT;
	frame.right -= 20;
	frame.left += 20;
	
	g1024x768Butt = new BRadioButton (frame, "1024x768", "1024x768", new BMessage ('x1x7'));
	if (gTheSettings->screen == B_8_BIT_1024x768)
	{
		g1024x768Butt->SetValue (B_CONTROL_ON);
	}
	g1024x768Butt->SetTarget (theScreen);
	theScreen->AddChild (g1024x768Butt);

	frame.top += theControlTop;
	frame.bottom = frame.top + B_H_SCROLL_BAR_HEIGHT;

	g800x600Butt = new BRadioButton (frame, "800x600", "800x600", new BMessage ('x8x6'));
	if (gTheSettings->screen == B_8_BIT_800x600)
	{
		g800x600Butt->SetValue (B_CONTROL_ON);
	}
	g800x600Butt->SetTarget (theScreen);
	theScreen->AddChild (g800x600Butt);

	frame.top += theControlTop;
	frame.bottom = frame.top + B_H_SCROLL_BAR_HEIGHT;

	g640x480Butt = new BRadioButton (frame, "640x480", "640x480", new BMessage ('x6x4'));
	if (gTheSettings->screen == B_8_BIT_640x480)
	{
		g640x480Butt->SetValue (B_CONTROL_ON);
	}
	g640x480Butt->SetTarget (theScreen);
	theScreen->AddChild (g640x480Butt);

// Back to default 	
	frame = theScreen->Bounds();
	frame.top = frame.bottom - (B_H_SCROLL_BAR_HEIGHT * 2);
	frame.bottom = frame.top + 12.0;
	frame.left += 40.0;
	frame.right -= 40.0;	
	
	BButton* gDefaults = new  BButton (frame, "", "Defaults", new BMessage ('xDFL'), B_FOLLOW_LEFT|B_FOLLOW_TOP, B_WILL_DRAW );
	gDefaults->SetTarget (theScreen);
	theScreen->AddChild(gDefaults);
	
// add message filter for default message
	BMessageFilter *mFilter = new BMessageFilter (B_ANY_DELIVERY, B_ANY_SOURCE, 
												   &filter_msg);
	theScreen->AddFilter (mFilter);	
	

// Create Clover view
	theControlTop = 5;
	frame = theClover->Bounds();
	frame.top += theControlTop;
	frame.left += 10.0;
	frame.bottom = frame.top + 12.0;
	view = new BStringView(frame, B_EMPTY_STRING, "Clover Rotation Speed (degrees per cycle)");
	theClover->AddChild(view);
	view->SetViewColor(theClover->ViewColor());
	
	theControlTop +=20;
	frame = theClover->Bounds();
	frame.top += theControlTop;
	frame.bottom = frame.top + B_H_SCROLL_BAR_HEIGHT;
	frame.right -= 20;
	frame.left = frame.right - 70;
	
	BTextControl *caption = new BTextControl(frame, NULL,  NULL, "", NULL,  B_FOLLOW_LEFT|B_FOLLOW_TOP, B_WILL_DRAW);
	theClover->AddChild(caption);
	caption->SetViewColor(theClover->ViewColor());
	caption->SetDrawingMode(B_OP_OVER);
	caption->SetFont(be_plain_font);
		
	frame.right = frame.left - 10;
	frame.left = theClover->Bounds().left + 40;
	gSlideCloRot = new TControlSlide(frame, NULL, caption,0, 2879, B_HORIZONTAL, 8, "%.3f");
	theClover->AddChild(gSlideCloRot);
	gSlideCloRot->SetValue(gTheSettings->CloverRotation);
	

// CloverSpacing
	theControlTop +=20;
	frame = theClover->Bounds();
	frame.top += theControlTop;
	frame.left += 10.0;
	frame.bottom = frame.top + 12.0;
	view = new BStringView(frame, B_EMPTY_STRING, "Dot Spacing (cycles per dot)");
	theClover->AddChild(view);
	view->SetViewColor(theClover->ViewColor());

	theControlTop +=20;
	frame = theClover->Bounds();
	frame.top += theControlTop;
	frame.bottom = frame.top + B_H_SCROLL_BAR_HEIGHT;
	frame.right -= 20;
	frame.left = frame.right - 70;
	
	caption = new BTextControl(frame, NULL,  NULL, "", NULL, B_FOLLOW_LEFT|B_FOLLOW_TOP, B_WILL_DRAW);
	theClover->AddChild(caption);
	caption->SetViewColor(theClover->ViewColor());
	caption->SetDrawingMode(B_OP_OVER);
	caption->SetFont(be_plain_font);
		
	frame.right = frame.left - 10;
	frame.left = theClover->Bounds().left + 40;
	gSlideCloSpa = new TControlSlide(frame, NULL, caption,1, 2879, B_HORIZONTAL, 1, "%.0f");
	theClover->AddChild(gSlideCloSpa);
	gSlideCloSpa->SetValue(gTheSettings->CloverSpacing);

// CloverSpeed
	theControlTop+=20;
	frame = theClover->Bounds();
	frame.top += theControlTop;
	frame.left += 10.0;
	frame.bottom = frame.top + 12.0;
	view = new BStringView(frame, B_EMPTY_STRING, "Dot Speed (degrees per cycle)");
	theClover->AddChild(view);
	view->SetViewColor(theClover->ViewColor());

	theControlTop +=20;
	frame = theClover->Bounds();
	frame.top += theControlTop;
	frame.bottom = frame.top + B_H_SCROLL_BAR_HEIGHT;
	frame.right -= 20;
	frame.left = frame.right - 70;
	
	caption = new BTextControl(frame, NULL,  NULL, "", NULL, B_FOLLOW_LEFT|B_FOLLOW_TOP, B_WILL_DRAW);
	theClover->AddChild(caption);
	caption->SetViewColor(theClover->ViewColor());
	caption->SetDrawingMode(B_OP_OVER);
	caption->SetFont(be_plain_font);

	frame.right = frame.left - 10;
	frame.left = theClover->Bounds().left + 40;
	gSlideCloSpe = new TControlSlide(frame, NULL, caption,1, 2879, B_HORIZONTAL, 8, "%.3f");
	theClover->AddChild(gSlideCloSpe);
	gSlideCloSpe->SetValue(gTheSettings->CloverSpeed);

// Setup Circle Parameters

// VariableMaxRotation
	theControlTop=5;
	frame = theCircle->Bounds();
	frame.top += theControlTop;
	frame.left += 10.0;
	frame.bottom = frame.top + 12.0;
	view = new BStringView(frame, B_EMPTY_STRING, "Max Rotation Speed (degrees per cycle)");
	theCircle->AddChild(view);
	view->SetViewColor(theCircle->ViewColor());

	theControlTop +=20;
	frame = theCircle->Bounds();
	frame.top += theControlTop;
	frame.bottom = frame.top + B_H_SCROLL_BAR_HEIGHT;
	frame.right -= 20;
	frame.left = frame.right - 70;
	
	caption = new BTextControl(frame, NULL,  NULL, "", NULL, B_FOLLOW_LEFT|B_FOLLOW_TOP, B_WILL_DRAW);
	theCircle->AddChild(caption);
	caption->SetViewColor(theCircle->ViewColor());
	caption->SetDrawingMode(B_OP_OVER);
	caption->SetFont(be_plain_font);

	frame.right = frame.left - 10;
	frame.left = theCircle->Bounds().left + 40;
	gSlideVarMax = new TControlSlide(frame, NULL, caption,1, 80, B_HORIZONTAL, 8, "%.3f");
	theCircle->AddChild(gSlideVarMax);
	gSlideVarMax->SetValue(gTheSettings->VariableMaxRotation);
	
// VariableSpacing
	theControlTop+=20;
	frame = theCircle->Bounds();
	frame.top += theControlTop;
	frame.left += 10.0;
	frame.bottom = frame.top + 12.0;
	view = new BStringView(frame, B_EMPTY_STRING, "Dot Spacing (cycles per dot)");
	theCircle->AddChild(view);
	view->SetViewColor(theCircle->ViewColor());

	theControlTop +=20;
	frame = theCircle->Bounds();
	frame.top += theControlTop;
	frame.bottom = frame.top + B_H_SCROLL_BAR_HEIGHT;
	frame.right -= 20;
	frame.left = frame.right - 70;
	
	caption = new BTextControl(frame, NULL,  NULL, "", NULL, B_FOLLOW_LEFT|B_FOLLOW_TOP, B_WILL_DRAW);
	theCircle->AddChild(caption);
	caption->SetViewColor(theCircle->ViewColor());
	caption->SetDrawingMode(B_OP_OVER);
	caption->SetFont(be_plain_font);

	frame.right = frame.left - 10;
	frame.left = theCircle->Bounds().left + 40;
	gSlideVarSpa = new TControlSlide(frame, NULL, caption,1, 2879, B_HORIZONTAL, 1, "%.0f");
	theCircle->AddChild(gSlideVarSpa);
	gSlideVarSpa->SetValue(gTheSettings->VariableSpacing);
	
// VariableSpeed
	theControlTop+=20;
	frame = theCircle->Bounds();
	frame.top += theControlTop;
	frame.left += 10.0;
	frame.bottom = frame.top + 12.0;
	view = new BStringView(frame, B_EMPTY_STRING, "Dot Speed (degrees per cycle)");
	theCircle->AddChild(view);
	view->SetViewColor(theCircle->ViewColor());

	theControlTop +=20;
	frame = theCircle->Bounds();
	frame.top += theControlTop;
	frame.bottom = frame.top + B_H_SCROLL_BAR_HEIGHT;
	frame.right -= 20;
	frame.left = frame.right - 70;
	
	caption = new BTextControl(frame, NULL,  NULL, "", NULL, B_FOLLOW_LEFT|B_FOLLOW_TOP, B_WILL_DRAW);
	theCircle->AddChild(caption);
	caption->SetViewColor(theCircle->ViewColor());
	caption->SetDrawingMode(B_OP_OVER);
	caption->SetFont(be_plain_font);

	frame.right = frame.left - 10;
	frame.left = theCircle->Bounds().left + 40;
	gSlideVarSpe = new TControlSlide(frame, NULL, caption,1, 2879, B_HORIZONTAL, 8, "%.3f");
	theCircle->AddChild(gSlideVarSpe);
	gSlideVarSpe->SetValue(gTheSettings->VariableSpeed);
	
// Variablechance
	theControlTop+=20;
	frame = theCircle->Bounds();
	frame.top += theControlTop;
	frame.left += 10.0;
	frame.bottom = frame.top + 12.0;
	view = new BStringView(frame, B_EMPTY_STRING, "Direction Change Chance");
	theCircle->AddChild(view);
	view->SetViewColor(theCircle->ViewColor());

	theControlTop +=20;
	frame = theCircle->Bounds();
	frame.top += theControlTop;
	frame.bottom = frame.top + B_H_SCROLL_BAR_HEIGHT;
	frame.right -= 20;
	frame.left = frame.right - 70;
	
	caption = new BTextControl(frame, NULL,  NULL, "", NULL, B_FOLLOW_LEFT|B_FOLLOW_TOP, B_WILL_DRAW);
	theCircle->AddChild(caption);
	caption->SetViewColor(theCircle->ViewColor());
	caption->SetDrawingMode(B_OP_OVER);
	caption->SetFont(be_plain_font);

	frame.right = frame.left - 10;
	frame.left = theCircle->Bounds().left + 40;
	gSlideVarCha = new TControlSlide(frame, NULL, caption,1, 2879, B_HORIZONTAL, 1, "%.0f");
	theCircle->AddChild(gSlideVarCha);
	gSlideVarCha->SetValue(gTheSettings->VariableChance);

// sphere View Setup

// SphereDelay
	theControlTop=5;
	frame = theSphere->Bounds();
	frame.top += theControlTop;
	frame.left += 10.0;
	frame.bottom = frame.top + 12.0;
	view = new BStringView(frame, B_EMPTY_STRING, "New Ring Delay (cycles per ring)");
	theSphere->AddChild(view);
	view->SetViewColor(theSphere->ViewColor());

	theControlTop +=20;
	frame = theSphere->Bounds();
	frame.top += theControlTop;
	frame.bottom = frame.top + B_H_SCROLL_BAR_HEIGHT;
	frame.right -= 20;
	frame.left = frame.right - 70;
	
	caption = new BTextControl(frame, NULL,  NULL, "", NULL, B_FOLLOW_LEFT|B_FOLLOW_TOP, B_WILL_DRAW);
	theSphere->AddChild(caption);
	caption->SetViewColor(theSphere->ViewColor());
	caption->SetDrawingMode(B_OP_OVER);
	caption->SetFont(be_plain_font);

	frame.right = frame.left - 10;
	frame.left = theSphere->Bounds().left + 40;
	gSlideSphDel = new TControlSlide(frame, NULL, caption,1, 100, B_HORIZONTAL, 1, "%.0f");
	theSphere->AddChild(gSlideSphDel);
	gSlideSphDel->SetValue(gTheSettings->SphereDelay);

// SphereSpeed
	theControlTop+=20;
	frame = theSphere->Bounds();
	frame.top += theControlTop;
	frame.left += 10.0;
	frame.bottom = frame.top + 12.0;
	view = new BStringView(frame, B_EMPTY_STRING, "Rotation Speed (degrees per cycle)");
	theSphere->AddChild(view);
	view->SetViewColor(theSphere->ViewColor());

	theControlTop +=20;
	frame = theSphere->Bounds();
	frame.top += theControlTop;
	frame.bottom = frame.top + B_H_SCROLL_BAR_HEIGHT;
	frame.right -= 20;
	frame.left = frame.right - 70;
	
	caption = new BTextControl(frame, NULL,  NULL, "", NULL, B_FOLLOW_LEFT|B_FOLLOW_TOP, B_WILL_DRAW);
	theSphere->AddChild(caption);
	caption->SetViewColor(theSphere->ViewColor());
	caption->SetDrawingMode(B_OP_OVER);
	caption->SetFont(be_plain_font);

	frame.right = frame.left - 10;
	frame.left = theSphere->Bounds().left + 40;
	gSlideSphSpe = new TControlSlide(frame, NULL, caption,1, 40, B_HORIZONTAL, 8, "%.3f");
	theSphere->AddChild(gSlideSphSpe);
	gSlideSphSpe->SetValue(gTheSettings->SphereSpeed);

// Ring View Setup

// SpinRotation
	theControlTop=5;
	frame = theRing->Bounds();
	frame.top += theControlTop;
	frame.left += 10.0;
	frame.bottom = frame.top + 12.0;
	view = new BStringView(frame, B_EMPTY_STRING, "Rotation Speed (degrees per cycle)");
	theRing->AddChild(view);
	view->SetViewColor(theRing->ViewColor());

	theControlTop +=20;
	frame = theRing->Bounds();
	frame.top += theControlTop;
	frame.bottom = frame.top + B_H_SCROLL_BAR_HEIGHT;
	frame.right -= 20;
	frame.left = frame.right - 70;
	
	caption = new BTextControl(frame, NULL,  NULL, "", NULL, B_FOLLOW_LEFT|B_FOLLOW_TOP, B_WILL_DRAW);
	theRing->AddChild(caption);
	caption->SetViewColor(theRing->ViewColor());
	caption->SetDrawingMode(B_OP_OVER);
	caption->SetFont(be_plain_font);

	frame.right = frame.left - 10;
	frame.left = theRing->Bounds().left + 40;
	gSlideCirRot = new TControlSlide(frame, NULL, caption,0, 144, B_HORIZONTAL, 8, "%.3f");
	theRing->AddChild(gSlideCirRot);
	gSlideCirRot->SetValue(gTheSettings->CircleRotation);

// SpinSpacing
	theControlTop+=20;
	frame = theRing->Bounds();
	frame.top += theControlTop;
	frame.left += 10.0;
	frame.bottom = frame.top + 12.0;
	view = new BStringView(frame, B_EMPTY_STRING, "Dot Spacing (cycles per dot)");
	theRing->AddChild(view);
	view->SetViewColor(theRing->ViewColor());

	theControlTop +=20;
	frame = theRing->Bounds();
	frame.top += theControlTop;
	frame.bottom = frame.top + B_H_SCROLL_BAR_HEIGHT;
	frame.right -= 20;
	frame.left = frame.right - 70;
	
	caption = new BTextControl(frame, NULL,  NULL, "", NULL, B_FOLLOW_LEFT|B_FOLLOW_TOP, B_WILL_DRAW);
	theRing->AddChild(caption);
	caption->SetViewColor(theRing->ViewColor());
	caption->SetDrawingMode(B_OP_OVER);
	caption->SetFont(be_plain_font);

	frame.right = frame.left - 10;
	frame.left = theRing->Bounds().left + 40;
	gSlideCirSpa = new TControlSlide(frame, NULL, caption,1, 144, B_HORIZONTAL, 1, "%.0f");
	theRing->AddChild(gSlideCirSpa);
	gSlideCirSpa->SetValue(gTheSettings->CircleSpacing);

// SpinSpeed
	theControlTop+=20;
	frame = theRing->Bounds();
	frame.top += theControlTop;
	frame.left += 10.0;
	frame.bottom = frame.top + 12.0;
	view = new BStringView(frame, B_EMPTY_STRING, "Dot Speed (degrees per cycle)");
	theRing->AddChild(view);
	view->SetViewColor(theRing->ViewColor());

	theControlTop +=20;
	frame = theRing->Bounds();
	frame.top += theControlTop;
	frame.bottom = frame.top + B_H_SCROLL_BAR_HEIGHT;
	frame.right -= 20;
	frame.left = frame.right - 70;
	
	caption = new BTextControl(frame, NULL,  NULL, "", NULL, B_FOLLOW_LEFT|B_FOLLOW_TOP, B_WILL_DRAW);
	theRing->AddChild(caption);
	caption->SetViewColor(theRing->ViewColor());
	caption->SetDrawingMode(B_OP_OVER);
	caption->SetFont(be_plain_font);

	frame.right = frame.left - 10;
	frame.left = theRing->Bounds().left + 40;
	gSlideCirSpe = new TControlSlide(frame, NULL, caption,1, 40, B_HORIZONTAL, 8, "%.3f");
	theRing->AddChild(gSlideCirSpe);
	gSlideCirSpe->SetValue(gTheSettings->CircleSpeed);


// Settings View Setup
// MaxDots
	theControlTop=5;
	frame = theSettings->Bounds();
	frame.top += theControlTop;
	frame.left += 10.0;
	frame.bottom = frame.top + 12.0;
	view = new BStringView(frame, B_EMPTY_STRING, "Maximum Dots");
	theSettings->AddChild(view);
	view->SetViewColor(theSettings->ViewColor());

	theControlTop +=20;
	frame = theSettings->Bounds();
	frame.top += theControlTop;
	frame.bottom = frame.top + B_H_SCROLL_BAR_HEIGHT;
	frame.right -= 20;
	frame.left = frame.right - 70;
	
	caption = new BTextControl(frame, NULL,  NULL, "", NULL, B_FOLLOW_LEFT|B_FOLLOW_TOP, B_WILL_DRAW);
	theSettings->AddChild(caption);
	caption->SetViewColor(theSettings->ViewColor());
	caption->SetDrawingMode(B_OP_OVER);
	caption->SetFont(be_plain_font);

	frame.right = frame.left - 10;
	frame.left = theSettings->Bounds().left + 40;
	gSlideMaxDot = new TControlSlide(frame, NULL, caption,100, 1000, B_HORIZONTAL, 1, "%.0f");
	theSettings->AddChild(gSlideMaxDot);
	gSlideMaxDot->SetValue(gTheSettings->MaxDots);

// MaxGroups
	theControlTop+=20;
	frame = theSettings->Bounds();
	frame.top += theControlTop;
	frame.left += 10.0;
	frame.bottom = frame.top + 12.0;
	view = new BStringView(frame, B_EMPTY_STRING, "Maximum Groups");
	theSettings->AddChild(view);
	view->SetViewColor(theSettings->ViewColor());

	theControlTop +=20;
	frame = theSettings->Bounds();
	frame.top += theControlTop;
	frame.bottom = frame.top + B_H_SCROLL_BAR_HEIGHT;
	frame.right -= 20;
	frame.left = frame.right - 70;
	
	caption = new BTextControl(frame, NULL,  NULL, "", NULL, B_FOLLOW_LEFT|B_FOLLOW_TOP, B_WILL_DRAW);
	theSettings->AddChild(caption);
	caption->SetViewColor(theSettings->ViewColor());
	caption->SetDrawingMode(B_OP_OVER);
	caption->SetFont(be_plain_font);

	frame.right = frame.left - 10;
	frame.left = theSettings->Bounds().left + 40;
	gSlideMaxGro = new TControlSlide(frame, NULL, caption,5, 40, B_HORIZONTAL, 1, "%.0f");
	theSettings->AddChild(gSlideMaxGro);
	gSlideMaxGro->SetValue(gTheSettings->MaxGroups);

// NewGroupChance
	theControlTop+=20;
	frame = theSettings->Bounds();
	frame.top += theControlTop;
	frame.left += 10.0;
	frame.bottom = frame.top + 12.0;
	view = new BStringView(frame, B_EMPTY_STRING, "New Group Chance (1/chance per cycle)");
	theSettings->AddChild(view);
	view->SetViewColor(theSettings->ViewColor());

	theControlTop +=20;
	frame = theSettings->Bounds();
	frame.top += theControlTop;
	frame.bottom = frame.top + B_H_SCROLL_BAR_HEIGHT;
	frame.right -= 20;
	frame.left = frame.right - 70;
	
	caption = new BTextControl(frame, NULL,  NULL, "", NULL, B_FOLLOW_LEFT|B_FOLLOW_TOP, B_WILL_DRAW);
	theSettings->AddChild(caption);
	caption->SetViewColor(theSettings->ViewColor());
	caption->SetDrawingMode(B_OP_OVER);
	caption->SetFont(be_plain_font);

	frame.right = frame.left - 10;
	frame.left = theSettings->Bounds().left + 40;
	gSlideChance = new TControlSlide(frame, NULL, caption,20, 1000, B_HORIZONTAL, 1, "%.0f");
	theSettings->AddChild(gSlideChance);
	gSlideChance->SetValue(gTheSettings->GroupChance);

// FrameSpeed
	theControlTop+=20;
	frame = theSettings->Bounds();
	frame.top += theControlTop;
	frame.left += 10.0;
	frame.bottom = frame.top + 12.0;
	view = new BStringView(frame, B_EMPTY_STRING, "Max. Cycles Per Second");
	theSettings->AddChild(view);
	view->SetViewColor(theSettings->ViewColor());

	theControlTop +=20;
	frame = theSettings->Bounds();
	frame.top += theControlTop;
	frame.bottom = frame.top + B_H_SCROLL_BAR_HEIGHT;
	frame.right -= 20;
	frame.left = frame.right - 70;
	
	caption = new BTextControl(frame, NULL,  NULL, "", NULL, B_FOLLOW_LEFT|B_FOLLOW_TOP, B_WILL_DRAW);
	theSettings->AddChild(caption);
	caption->SetViewColor(theSettings->ViewColor());
	caption->SetDrawingMode(B_OP_OVER);
	caption->SetFont(be_plain_font);

	frame.right = frame.left - 10;
	frame.left = theSettings->Bounds().left + 40;
	gSlideFrame = new TControlSlide(frame, NULL, caption,5, 200, B_HORIZONTAL, 1, "%.0f");
	theSettings->AddChild(gSlideFrame);
	gSlideFrame->SetValue(gTheSettings->FrameTime);

// Erase
	theControlTop+=20;
	frame = theSettings->Bounds();
	frame.top += theControlTop;
	frame.left += 20.0;
	frame.bottom = frame.top + 12.0;
	gCheckErase = new  BCheckBox(frame, "", "Erase Each Cycle",NULL,
								   B_FOLLOW_LEFT|B_FOLLOW_TOP, B_WILL_DRAW );
	theSettings->AddChild(gCheckErase);
	gCheckErase->SetValue(gTheSettings->Erase);
	
	
	
	inView->Window()->UpdateIfNeeded();
	
	inView->Window()->Unlock();
	
	gConfiguring = 1;
	
}


// ------------------------------------------------------------
// 		 module_stop_config  [required]
// ------------------------------------------------------------
// This function gets called right before the BView that was passed
// to you in module_start_config() gets deleted
//
// Free any memory that you may have allocated, you know the game...
//
// Since your view will be deleted, it is not necessary to delete 
// the children that you added to it

void
module_stop_config()
{
	GetSettings();
	gConfiguring = 0;

}

void
SetSettings()
{
	gSlideCloRot->SetValue (gTheSettings->CloverRotation);
	gSlideCloSpa->SetValue (gTheSettings->CloverSpacing);
	gSlideCloSpe->SetValue (gTheSettings->CloverSpeed);
	gSlideVarMax->SetValue (gTheSettings->VariableMaxRotation);
	gSlideVarSpa->SetValue (gTheSettings->VariableSpacing);
	gSlideVarSpe->SetValue (gTheSettings->VariableSpeed );
	gSlideVarCha->SetValue (gTheSettings->VariableChance);
	gSlideSphDel->SetValue (gTheSettings->SphereDelay);
	gSlideSphSpe->SetValue (gTheSettings->SphereSpeed );
	gSlideChance->SetValue (gTheSettings->GroupChance);
	gSlideCirRot->SetValue (gTheSettings->CircleRotation);
	gSlideCirSpa->SetValue (gTheSettings->CircleSpacing);
	gSlideCirSpe->SetValue (gTheSettings->CircleSpeed);
	gSlideMaxDot->SetValue (gTheSettings->MaxDots);
	gSlideMaxGro->SetValue (gTheSettings->MaxGroups);
	gSlideFrame->SetValue (gTheSettings->FrameTime);
	gCheckErase->SetValue (gTheSettings->Erase);

	if (gTheSettings->screen == B_8_BIT_800x600)
	{
		g800x600Butt->SetValue (B_CONTROL_ON);
	}
	if (gTheSettings->screen == B_8_BIT_640x480)
	{
		g640x480Butt->SetValue (B_CONTROL_ON);
	}
	if (gTheSettings->screen == B_8_BIT_1024x768)
	{
		g1024x768Butt->SetValue (B_CONTROL_ON);
	}
}

void
GetSettings()
{
	gTheSettings->CloverRotation = gSlideCloRot->Value();
	gTheSettings->CloverSpacing = gSlideCloSpa->Value();
	gTheSettings->CloverSpeed = gSlideCloSpe->Value();
	gTheSettings->VariableMaxRotation = gSlideVarMax->Value();
	gTheSettings->VariableSpacing = gSlideVarSpa->Value();
	gTheSettings->VariableSpeed = gSlideVarSpe->Value();
	gTheSettings->VariableChance = gSlideVarCha->Value();
	gTheSettings->SphereDelay = gSlideSphDel->Value();
	gTheSettings->SphereSpeed = gSlideSphSpe->Value();
	gTheSettings->GroupChance = gSlideChance->Value();
	gTheSettings->CircleRotation = gSlideCirRot->Value();
	gTheSettings->CircleSpacing = gSlideCirSpa->Value();
	gTheSettings->CircleSpeed = gSlideCirSpe->Value();
	gTheSettings->MaxDots = gSlideMaxDot->Value();
	gTheSettings->MaxGroups = gSlideMaxGro->Value();
	gTheSettings->FrameTime = gSlideFrame->Value();
	gTheSettings->Erase = gCheckErase->Value();
	// Tell Dots everything
	CopySettingsIn(gTheSettings);
}

filter_result filter_msg (BMessage* message, BHandler **target, 
						   BMessageFilter *messageFilter)
{
	switch (message->what)
	{
		case 'xDFL':
			// Set settings back to default
			*gTheSettings = *gDefSettings;
			SetSettings();
			CopySettingsIn (gTheSettings);
			break;
		case 'x8x6':
			// screen size
			gTheSettings->screen = B_8_BIT_800x600; 
			break;
		case 'x6x4':
			gTheSettings->screen = B_8_BIT_640x480;
			break;
		case 'x1x7':
			gTheSettings->screen = B_8_BIT_1024x768;
			break;
		default: break;
	}
	
	return B_DISPATCH_MESSAGE;
}